﻿// Exports chart to PDF.
// Depends on jquery, pdfmake
class ChartPdfExporter {
    // The product name
    productName = "Rapid SCADA";

    // Creates a PDF document definition.
    _createPdfDoc(canvasDomElem, titleText, statusText) {
        return {
            pageSize: "A4",
            pageOrientation: "landscape",
            pageMargins: [30, 25, 30, 25],

            content: this._createPdfContent(canvasDomElem, titleText, statusText),

            footer: {
                text: this.productName,
                style: "chartFooterStyle"
            },

            styles: this._createPdfStyles()
        };
    }

    // Creates an object that describes PDF content for the pdf maker.
    _createPdfContent(canvasDomElem, titleText, statusText) {
        return [
            {
                columns: [
                    {
                        width: "*",
                        text: titleText,
                        style: "chartTitleStyle"
                    },
                    {
                        width: "auto",
                        text: statusText,
                        style: "chartStatusStyle"
                    }
                ],
                columnGap: 10
            },
            {
                image: canvasDomElem.toDataURL(),
                fit: [780, 500]
            }
        ];
    }

    // Creates an object that describes PDF styles for the pdf maker.
    _createPdfStyles() {
        return {
            chartTitleStyle: {
                fontSize: 14,
                bold: true,
                margin: [0, 0, 0, 5]
            },
            chartStatusStyle: {
                fontSize: 8,
                margin: [0, 5, 0, 5]
            },
            chartFooterStyle: {
                fontSize: 8,
                alignment: "right",
                margin: [0, 0, 30, 0]
            }
        };
    }

    // Exports chart to PDF.
    export(chartElemID, fileName) {
        let chartElem = $("#" + chartElemID);
        let canvasElem = chartElem.find("canvas:first");

        if (canvasElem.length > 0) {
            let titleText = chartElem.find(".chart-title-text:first").text();
            let statusText = chartElem.find(".chart-status span:first").text();
            let docDefinition = this._createPdfDoc(canvasElem[0], titleText, statusText);
            pdfMake.createPdf(docDefinition).download(fileName); // performed by pdfmake
        } else {
            console.error("Canvas not found");
        }
    }
}
