﻿class PeriodControl {
    static NONE = 0;
    static SINGLE_DATE = 1;
    static SINGLE_MONTH = 2;
    static DATE_PERIOD = 3;
    static DATE_TIME_PERIOD = 4;
    static MONTH_PERIOD = 5;
};

function getStartTime(periodControl, defaultStartTime) {
    let startTime = $("#txtStartTime").val();

    switch (periodControl) {
        case PeriodControl.SINGLE_DATE:
        case PeriodControl.DATE_PERIOD:
        case PeriodControl.DATE_TIME_PERIOD:
            return startTime;

        case PeriodControl.SINGLE_MONTH:
        case PeriodControl.MONTH_PERIOD:
            return startTime + "-01";

        default:
            return defaultStartTime;
    }
}

function getEndTime(periodControl, defaultEndTime, tune) {
    let startTime = $("#txtStartTime").val();
    let endTime = $("#txtEndTime").val();

    switch (periodControl) {
        case PeriodControl.SINGLE_DATE:
            return tune ? addDay(startTime) : startTime;

        case PeriodControl.DATE_PERIOD:
            return tune ? addDay(endTime) : endTime;

        case PeriodControl.DATE_TIME_PERIOD:
            return endTime;

        case PeriodControl.SINGLE_MONTH:
            startTime += "-01";
            return tune ? addMonth(startTime) : startTime;

        case PeriodControl.MONTH_PERIOD:
            endTime += "-01";
            return tune ? addMonth(endTime) : endTime;

        default:
            return defaultEndTime;
    }
}

function addDay(dateStr) {
    let date = ScadaUtils.addDay(dateStr);
    return ScadaUtils.dateToString(date);
}

function addMonth(dateStr) {
    let date = ScadaUtils.addMonth(dateStr);
    return ScadaUtils.dateToString(date);
}
