﻿// Set in ReportArgs.cshtml
var reportID = 0;
var inputOptions = {};
var defaultStartTime = "";
var defaultEndTime = "";
var phrases = {};

function hideErrorMessage() {
    $("#divErrorMessage").addClass("d-none");
}

function reportValidityExtra() {
    let errors = [];

    // time range
    let startTimeMs = Date.parse(getStartTime(inputOptions.periodControl, defaultStartTime));
    let endTimeMs = Date.parse(getEndTime(inputOptions.periodControl, defaultEndTime, false));

    if (startTimeMs > endTimeMs) {
        errors.push(phrases.invalidPeriod);
    } else if (endTimeMs - startTimeMs > inputOptions.maxPeriod * ScadaUtils.MS_PER_DAY) {
        errors.push(ScadaUtils.formatString(phrases.periodTooLong, inputOptions.maxPeriod));
    }

    // channel numbers
    let txtCnlNums = $("#txtCnlNums");

    if (txtCnlNums.length > 0) {
        let cnlNums = ScadaUtils.parseRange(txtCnlNums.val());

        if (!(cnlNums && cnlNums.length > 0)) {
            errors.push(phrases.invalidChannels);
        }
    }

    if (errors.length > 0) {
        $("#divErrorMessage")
            .html(errors.join("<br />"))
            .removeClass("d-none");
        return false;
    } else {
        return true;
    }
}

function lockGenerateButton() {
    $("#btnGenerateReport").prop("disabled", true);
    $("#divWaitHint").removeClass("d-none");

    setTimeout(function () {
        $("#btnGenerateReport").prop("disabled", false);
        $("#divWaitHint").addClass("d-none");
    }, ScadaUtils.BUTTON_LOCK_DURATION);
}

function getReportUrl() {
    let reportUrl = "../Print/PrintReport1" +
        "?reportID=" + reportID +
        "&startTime=" + getStartTime(inputOptions.periodControl, defaultStartTime) +
        "&endTime=" + getEndTime(inputOptions.periodControl, defaultEndTime, true) +
        "&archive=" + getSelectedArchive() +
        "&format=" + getSelectedFormat();

    if (inputOptions.selectChannels) {
        reportUrl += "&cnlNums=" + $("#txtCnlNums").val();
    }

    return reportUrl;
}

function getSelectedArchive() {
    return inputOptions.selectArchive
        ? $("#selArchive option:selected").val()
        : inputOptions.defaultArchive;
}

function getSelectedFormat() {
    return inputOptions.selectFormat
        ? $("input[name=outputFormat]:checked").val()
        : inputOptions.defaultFormatStr;
}

$(function () {
    $("#btnGenerateReport").on("click", function () {
        hideErrorMessage();

        if ($("#frmReportArgs")[0].reportValidity() && reportValidityExtra()) {
            lockGenerateButton();
            let reportUrl = getReportUrl();

            if (getSelectedFormat() === "Html") {
                window.open(reportUrl);
            } else {
                location = reportUrl;
            }
        }

        return false;
    });

    $("#btnSelectCnls").on("click", function () {
        let dialogs = new Dialogs("../../");
        let txtCnlNums = $("#txtCnlNums");

        dialogs.selectChannels(txtCnlNums.val(), function (result) {
            if (result) {
                txtCnlNums.val(result.cnlNums);
            }
        });

        return false;
    });
});
