class AlingActionType{static ALIGN_LEFTS="align-lefts";static ALIGN_CENTERS="align-centers";static ALIGN_RIGHTS="align-rights";static ALIGN_TOPS="align-tops";static ALIGN_MIDDLES="align-middles";static ALIGN_BOTTOMS="align-bottoms";static SAME_WIDTH="same-width";static SAME_HEIGHT="same-height";static SAME_SIZE="same-size";static HOR_SPACING="hor-spacing";static VERT_SPACING="vert-spacing";static sameParentRequired(n){return n===AlingActionType.ALIGN_LEFTS||n===AlingActionType.ALIGN_CENTERS||n===AlingActionType.ALIGN_RIGHTS||n===AlingActionType.ALIGN_TOPS||n===AlingActionType.ALIGN_MIDDLES||n===AlingActionType.ALIGN_BOTTOMS||n===AlingActionType.HOR_SPACING||n===AlingActionType.VERT_SPACING}}class ArrangeActionType{static SEND_TO_BACK="send-to-back";static SEND_BACKWARD="send-backward";static BRING_FORWARD="bring-forward";static BRING_TO_FRONT="bring-to-front";static PLACE_BEFORE="place-before";static PLACE_AFTER="place-after";static SELECT_PARENT="select-parent";static longActionRequired(n){return n===ArrangeActionType.PLACE_BEFORE||n===ArrangeActionType.PLACE_AFTER||n===ArrangeActionType.SELECT_PARENT}}class ChangeType{static ADD_DEPENDENCY="AddDependency";static REMOVE_DEPENDENCY="RemoveDependency";static UPDATE_DOCUMENT="UpdateDocument";static ADD_COMPONENT="AddComponent";static UPDATE_COMPONENT="UpdateComponent";static UPDATE_PARENT="UpdateParent";static ARRANGE_COMPONENT="ArrangeComponent";static REMOVE_COMPONENT="RemoveComponent";static ADD_IMAGE="AddImage";static REMOVE_IMAGE="RemoveImage";}class DragType{static NONE=0;static MOVE=1;static RESIZE_LEFT=2;static RESIZE_RIGHT=3;static RESIZE_TOP=4;static RESIZE_BOT=5;static RESIZE_TOP_LEFT=6;static RESIZE_TOP_RIGHT=7;static RESIZE_BOT_LEFT=8;static RESIZE_BOT_RIGHT=9;static getCursor(n){if(n)switch(n){case DragType.MOVE:return"move";case DragType.RESIZE_LEFT:case DragType.RESIZE_RIGHT:return"ew-resize";case DragType.RESIZE_TOP:case DragType.RESIZE_BOT:return"ns-resize";case DragType.RESIZE_TOP_LEFT:case DragType.RESIZE_BOT_RIGHT:return"nwse-resize";case DragType.RESIZE_TOP_RIGHT:case DragType.RESIZE_BOT_LEFT:return"nesw-resize"}return""}static isResizeLeft(n){return n===DragType.RESIZE_LEFT||n===DragType.RESIZE_TOP_LEFT||n===DragType.RESIZE_BOT_LEFT}static isResizeRight(n){return n===DragType.RESIZE_RIGHT||n===DragType.RESIZE_TOP_RIGHT||n===DragType.RESIZE_BOT_RIGHT}static isResizeTop(n){return n===DragType.RESIZE_TOP||n===DragType.RESIZE_TOP_LEFT||n===DragType.RESIZE_TOP_RIGHT}static isResizeBot(n){return n===DragType.RESIZE_BOT||n===DragType.RESIZE_BOT_LEFT||n===DragType.RESIZE_BOT_RIGHT}}class EnabledDependsOn{static NOT_SPECIFIED=0;static SELECTION=1;static HISTORY=2;}class LongActionType{static NONE=0;static ADD=1;static PASTE=2;static DRAG=3;static ARRANGE=4;static isPointing(n){return n===LongActionType.ADD||n===LongActionType.PASTE||n===LongActionType.ARRANGE}}class MessageType{static INFO=0;static SUCCESS=1;static WARNING=2;static ERROR=3;}class ToolbarButton{static RELOAD="#btnReload";static SAVE="#btnSave";static UNDO="#btnUndo";static REDO="#btnRedo";static CUT="#btnCut";static COPY="#btnCopy";static PASTE="#btnPaste";static REMOVE="#btnRemove";static POINTER="#btnPointer";static ALIGN="button.rs-btn-align";static ARRANGE="button.rs-btn-arrange";}class Change{static MAX_SHIFT=1e6;changeType="";objectID=0;objectIDs=null;objectName="";properties=null;parentID=0;shift=0;siblingID=0;indexes=null;constructor(n){this.changeType=n}_setObjectID(n){Array.isArray(n)?n.length===1?this.objectID=n[0]:this.objectIDs=n:this.objectID=n}getObjectIDs(){return this.objectID>0?[this.objectID]:this.objectIDs??[]}setProperty(n,t){return this.properties??={},this.properties[n]=t,this}static addDependency(n){let t=new Change(ChangeType.ADD_DEPENDENCY);return t.objectName=n.typeName,t.properties=Object.assign({},n),t}static removeDependency(n){let t=new Change(ChangeType.REMOVE_DEPENDENCY);return t.objectName=n,t}static updateDocument(n){let t=new Change(ChangeType.UPDATE_DOCUMENT);return n&&(t.properties=Object.assign({},n)),t}static addComponent(n){let t=new Change(ChangeType.ADD_COMPONENT);return t.objectID=n.id,t.properties=Object.assign({},n.properties),t.properties.name=n.name,t.properties.typeName=n.typeName,t.parentID=n.parentID,t.index=n.index,t}static updateComponent(n,t){let i=new Change(ChangeType.UPDATE_COMPONENT);return i._setObjectID(n),t&&(i.properties=Object.assign({},t)),i}static updateLocation(n){return Change.updateComponent(n.id,{location:n.properties.location})}static updateSize(n){return Change.updateComponent(n.id,{size:n.properties.size})}static updateParent(n){let t=new Change(ChangeType.UPDATE_PARENT);return t.objectID=n.id,t.properties={location:n.properties.location},t.parentID=n.parentID,t.index=n.index,t}static arrangeComponent(n,t,i,r){let u=new Change(ChangeType.ARRANGE_COMPONENT);return u._setObjectID(t),u.parentID=n,u.shift=i,u.siblingID=r,u}static arrangeByIndexes(n,t,i){let r=new Change(ChangeType.ARRANGE_COMPONENT);return r.objectIDs=t,r.parentID=n,r.indexes=i,r}static removeComponent(n){let t=new Change(ChangeType.REMOVE_COMPONENT);return t._setObjectID(n),t}static addImage(n){let t=new Change(ChangeType.ADD_IMAGE);return t.objectName=n.name,t.properties=Object.assign({},n),t}static removeImage(n){let t=new Change(ChangeType.REMOVE_IMAGE);return t.objectName=n,t}}class UpdateDto{mimicKey;changes;json;constructor(n,t){this.mimicKey=n;this.changes=t??[];this.json=JSON.stringify({mimicKey:this.mimicKey,changes:this.changes})}}class LongAction{actionType;componentTypeName;dragType;startPoint;moved;resized;arrangeType;constructor(n){this.actionType=n??LongActionType.NONE}getCursor(){return this.actionType===LongActionType.ADD||this.actionType===LongActionType.PASTE?"crosshair":this.actionType===LongActionType.DRAG?DragType.getCursor(this.dragType):this.actionType===LongActionType.ARRANGE?"pointer":""}static add(n){let t=new LongAction(LongActionType.ADD);return t.componentTypeName=n,t}static paste(){return new LongAction(LongActionType.PASTE)}static drag(n,t){let i=new LongAction(LongActionType.DRAG);return i.dragType=n,i.startPoint=t,i.moved=!1,i.resized=!1,i}static arrange(n){let t=new LongAction(LongActionType.ARRANGE);return t.arrangeType=n,t}}class QueueEmptyFlags{saveRequired=false;reloadRequired=false;fullReloadRequired=false;}class HistoryChange{changeType="";objectID=null;oldObjectJson=null;newObjectJson=null;oldIndex=null;newIndex=null;constructor(n){Object.assign(this,n)}getOldObject(){return this.oldObjectJson?JSON.parse(this.oldObjectJson):null}getNewObject(){return this.newObjectJson?JSON.parse(this.newObjectJson):null}}class HistoryPoint{changes;constructor(n){this.changes=n??[]}toReversed(){let n=[];for(let t of this.changes.toReversed())switch(t.changeType){case ChangeType.UPDATE_DOCUMENT:n.push(new HistoryChange({changeType:ChangeType.UPDATE_DOCUMENT,oldObjectJson:t.newObjectJson,newObjectJson:t.oldObjectJson}));break;case ChangeType.ADD_COMPONENT:n.push(new HistoryChange({changeType:ChangeType.REMOVE_COMPONENT,objectID:t.objectID,oldObjectJson:t.newObjectJson}));break;case ChangeType.UPDATE_COMPONENT:n.push(new HistoryChange({changeType:ChangeType.UPDATE_COMPONENT,objectID:t.objectID,oldObjectJson:t.newObjectJson,newObjectJson:t.oldObjectJson}));break;case ChangeType.REMOVE_COMPONENT:n.push(new HistoryChange({changeType:ChangeType.ADD_COMPONENT,objectID:t.objectID,newObjectJson:t.oldObjectJson}));break;case ChangeType.UPDATE_PARENT:n.push(new HistoryChange({changeType:ChangeType.UPDATE_PARENT,objectID:t.objectID,oldObjectJson:t.newObjectJson,newObjectJson:t.oldObjectJson}));break;case ChangeType.ARRANGE_COMPONENT:n.push(new HistoryChange({changeType:ChangeType.ARRANGE_COMPONENT,objectID:t.objectID,oldIndex:t.newIndex,newIndex:t.oldIndex}))}return n.length>0?new HistoryPoint(n):null}}class MimicHistory{static MAX_SIZE=20;_points;_headIndex;_documentJson;_componentJsonMap;constructor(){this.clear()}get canUndo(){return this._headIndex>0}get canRedo(){return this._headIndex<this._points.length}_createHistoryChanges(n,t){let i=[];switch(n.changeType){case ChangeType.UPDATE_DOCUMENT:{let r=this._documentJson,n=JSON.stringify(t.document);this._documentJson=n;i.push(new HistoryChange({changeType:ChangeType.UPDATE_DOCUMENT,oldObjectJson:r,newObjectJson:n}));break}case ChangeType.ADD_COMPONENT:{let r=n.objectID,u=this._getComponentJsonFromMimic(r,t);this._updateComponentCache(r,u);i.push(new HistoryChange({changeType:ChangeType.ADD_COMPONENT,objectID:r,newObjectJson:u}));break}case ChangeType.UPDATE_COMPONENT:for(let r of n.getObjectIDs()){let u=this._getComponentJsonFromCache(r),n=this._getComponentJsonFromMimic(r,t);this._updateComponentCache(r,n);i.push(new HistoryChange({changeType:ChangeType.UPDATE_COMPONENT,objectID:r,oldObjectJson:u,newObjectJson:n}))}break;case ChangeType.REMOVE_COMPONENT:for(let t of n.getObjectIDs())i.push(new HistoryChange({changeType:ChangeType.REMOVE_COMPONENT,objectID:t,oldObjectJson:this._getComponentJsonFromCache(t)})),this._removeComponentFromCache(t);break;case ChangeType.UPDATE_PARENT:{let r=n.objectID,f=this._getComponentJsonFromCache(r),u=this._getComponentJsonFromMimic(r,t);this._updateComponentCache(r,u);i.push(new HistoryChange({changeType:ChangeType.UPDATE_PARENT,objectID:r,oldObjectJson:f,newObjectJson:u}));break}case ChangeType.ARRANGE_COMPONENT:for(let r of n.getObjectIDs()){let u=this._getComponentJsonFromCache(r),n=t.componentMap.get(r);if(this._updateComponentCache(r,n),u&&n){let t=JSON.parse(u);i.push(new HistoryChange({changeType:ChangeType.ARRANGE_COMPONENT,objectID:r,oldIndex:t.index,newIndex:n.index}))}}}return i}_getComponentJsonFromCache(n){return this._componentJsonMap.get(n)}_getComponentJsonFromMimic(n,t){let i=t.componentMap.get(n);return i?JSON.stringify(i.toPlainObject()):null}_updateComponentCache(n,t){t instanceof rs.mimic.Component?this._componentJsonMap.set(n,JSON.stringify(t.toPlainObject())):typeof t=="string"&&t?this._componentJsonMap.set(n,t):this._componentJsonMap.delete(n)}_removeComponentFromCache(n){this._componentJsonMap.delete(n)}clear(){this._points=[];this._headIndex=0;this._documentJson=null;this._componentJsonMap=new Map}rememberDocument(n,t){(t||!this._documentJson)&&(this._documentJson=JSON.stringify(n.document))}rememberComponent(n,t){(t||!this._componentJsonMap.has(n.id))&&this._updateComponentCache(n.id,n)}addPoint(n,t){let i=[];for(let r of t)r instanceof Change&&i.push(...this._createHistoryChanges(r,n));if(i.length>0){this._headIndex<this._points.length&&(this._points.length=this._headIndex);let t=new HistoryPoint(i);this._points.push(t);let n=this._points.length-MimicHistory.MAX_SIZE;n>0&&this._points.splice(0,n);this._headIndex=this._points.length}}getUndoPoint(){if(this._headIndex>0){this._headIndex--;let n=this._points[this._headIndex];return n.toReversed()}return null}getRedoPoint(){if(this._headIndex<this._points.length){let n=this._points[this._headIndex];return this._headIndex++,n}return null}}class MimicClipboard{static MARKER="MimicEditor";_isEmpty;_clipboardData;_componentJsons;_rootID;_offset;constructor(){this._clear()}get rootID(){return this._clipboardData?this._clipboardData.rootID:this._rootID}get offset(){return this._clipboardData?this._clipboardData.offset:this._offset}get isEmpty(){return this._isEmpty}_clear(){this._isEmpty=!0;this._clipboardData=null;this._componentJsons=[];this._rootID=0;this._offset={x:0,y:0}}static _validate(n){return n&&n.marker===MimicClipboard.MARKER&&Array.isArray(n.components)&&Number.isInteger(n.rootID)&&n.offset instanceof Object}async defineEmptiness(){if(this._componentJsons.length>0)this._isEmpty=!1;else try{this._isEmpty=!await navigator.clipboard.readText()}catch{this._isEmpty=!0}}async writeComponents(n){let t=[];if(this._clear(),Array.isArray(n)&&n.length>0){this._isEmpty=!1;this._rootID=n[0].parentID;this._offset=rs.mimic.MimicHelper.getMinLocation(n);for(let i of n)t.push(i.toPlainObject()),i.isContainer&&t.push(...i.getAllChildren().map(n=>n.toPlainObject()));this._componentJsons=t.map(n=>JSON.stringify(n))}try{await navigator.clipboard.writeText(JSON.stringify({marker:MimicClipboard.MARKER,components:t,rootID:this._rootID,offset:this._offset}))}catch(i){console.error("Error writing to clipboard: "+i.message)}}async readComponents(){try{let t=await navigator.clipboard.readText(),n;try{n=JSON.parse(t)}catch{n=null}if(MimicClipboard._validate(n))return this._clipboardData=n,n.components}catch(n){console.error("Error reading from clipboard: "+n.message)}return this._componentJsons.map(n=>JSON.parse(n))}}class ModalContext{oldValue=null;newValue=null;result=false;callback=null;constructor(n){Object.assign(this,n)}}class ModalBase{_elem;_modal;_context;constructor(n){this._elem=$("#"+n);this._modal=new bootstrap.Modal(this._elem[0]);this._context=new ModalContext}_invokeCallback(){this._context.result&&this._context.callback instanceof Function&&this._context.callback.call(this,this._context)}}class FaceplateModal extends ModalBase{constructor(n){super(n);this._bindEvents()}_bindEvents(){$("#frmFaceplateModal").on("submit",()=>($("#faceplateModal_btnOK").trigger("click"),!1));$("#faceplateModal_btnOK").on("click",()=>{let n=$("#frmFaceplateModal");n[0].checkValidity()&&(this._readFields(this._context.newValue),this._context.result=!0,this._modal.hide());n.addClass("was-validated")});this._elem.on("shown.bs.modal",()=>{$("#faceplateModal_txtTypeName").focus()}).on("hidden.bs.modal",()=>{this._invokeCallback()})}_showFields(n){$("#frmFaceplateModal").removeClass("was-validated");$("#faceplateModal_txtTypeName").val(n.typeName);$("#faceplateModal_txtPath").val(n.path)}_readFields(n){n.typeName=$("#faceplateModal_txtTypeName").val();n.path=$("#faceplateModal_txtPath").val()}show(n,t){let i=new rs.mimic.FaceplateMeta;Object.assign(i,n);this._context=new ModalContext({oldValue:n,newValue:i,callback:t});this._showFields(i);this._modal.show()}}class FontModal extends ModalBase{constructor(n){super(n);this._bindEvents()}_bindEvents(){$("#frmFontModal").on("submit",()=>($("#fontModal_btnOK").trigger("click"),!1));$("#fontModal_btnOK").on("click",()=>{this._readFields(this._context.newValue),this._context.result=!0,this._modal.hide()});$("#fontModal_chkInherit").on("change",n=>{let t=$(n.target).prop("checked");$("#fontModal_fsProps").prop("disabled",t)});this._elem.on("shown.bs.modal",()=>{$("#fontModal_chkInherit").focus()}).on("hidden.bs.modal",()=>{this._invokeCallback()})}_showFields(n){$("#fontModal_chkInherit").prop("checked",n.inherit);$("#fontModal_fsProps").prop("disabled",n.inherit);$("#fontModal_txtName").val(n.name);$("#fontModal_txtSize").val(n.size);$("#fontModal_chkBold").prop("checked",n.bold);$("#fontModal_chkItalic").prop("checked",n.italic);$("#fontModal_chkUnderline").prop("checked",n.underline)}_readFields(n){n.inherit=$("#fontModal_chkInherit").prop("checked");n.name=$("#fontModal_txtName").val();n.size=Number.parseInt($("#fontModal_txtSize").val());n.bold=$("#fontModal_chkBold").prop("checked");n.italic=$("#fontModal_chkItalic").prop("checked");n.underline=$("#fontModal_chkUnderline").prop("checked")}show(n,t){let i=new rs.mimic.Font(n);this._context=new ModalContext({oldValue:n,newValue:i,callback:t});this._showFields(i);this._modal.show()}}class ImageModal extends ModalBase{constructor(n){super(n);this._bindEvents()}_bindEvents(){$("#frmImageModal").on("submit",()=>($("#imageModal_btnOK").trigger("click"),!1));$("#imageModal_btnOK").on("click",()=>{let n=$("#frmImageModal");n[0].checkValidity()&&(this._readFields(this._context.newValue),this._context.result=!0,this._modal.hide());n.addClass("was-validated")});$("#imageModal_btnUpload").on("click",()=>{$("#imageModal_file").trigger("click")});$("#imageModal_btnDownload").on("click",n=>{let t=$(n.target);this._downloadImage(t)});$("#imageModal_file").on("change",n=>{let t=n.target.files[0];t&&this._uploadImage(t)});this._elem.on("shown.bs.modal",()=>{$("#imageModal_txtName").focus()}).on("hidden.bs.modal",()=>{this._invokeCallback()})}_showFields(n){$("#frmImageModal").removeClass("was-validated");$("#imageModal_txtName").val(n.name);$("#imageModal_file").val("")}_readFields(n){n.name=$("#imageModal_txtName").val();n.dataUrl=$("#imageModal_imgPreview").attr("src")}_showFileSize(n){$("#imageModal_spnFileSize").text(n?"("+Math.round(n/1024)+" KB)":"")}_getFileSize(n){return n?atob(n).length:0}_showImage(n){n?($("#imageModal_imgPreview").attr("src",n).removeClass("d-none"),$("#imageModal_divNoImage").addClass("d-none"),$("#imageModal_btnDownload").prop("disabled",!1)):($("#imageModal_imgPreview").attr("src","").addClass("d-none"),$("#imageModal_divNoImage").removeClass("d-none"),$("#imageModal_btnDownload").prop("disabled",!0))}_uploadImage(n){let t=new FileReader;t.onload=()=>{let i=$("#imageModal_txtName");i.val()||i.val(n.name);this._showFileSize(n.size);this._showImage(t.result)};t.onerror=()=>{console.error("Error reading file.")};t.readAsDataURL(n)}_downloadImage(n){let t=$("#imageModal_txtName").val(),i=$("#imageModal_imgPreview").attr("src");n.attr("download",t).attr("href",i)}show(n,t){let i=new rs.mimic.Image;Object.assign(i,n);this._context=new ModalContext({oldValue:n,newValue:i,callback:t});this._showFields(i);this._showFileSize(this._getFileSize(i.data));this._showImage(i.dataUrl);this._modal.show()}}class TextEditor extends ModalBase{static DEFAULT_OPTIONS={language:"none"};_flask;constructor(n){super(n);let t=$("#textEditor_divEditor");this._flask=new CodeFlask(t[0],TextEditor.DEFAULT_OPTIONS);this._bindEvents()}_bindEvents(){$("#textEditor_btnOK").on("click",()=>{this._context.newValue=this._flask.getCode(),this._context.result=!0,this._modal.hide()});this._elem.on("shown.bs.modal",()=>{$("#textEditor_divEditor textarea").focus()}).on("hidden.bs.modal",()=>{this._invokeCallback()})}_showLanguage(n){let t=$("#textEditor_lblLanguage");switch(n){case"css":t.text("CSS").removeClass("d-none");break;case"js":t.text("JavaScript").removeClass("d-none");break;case"markup":t.text("HTML/XML").removeClass("d-none");break;default:t.text("Text").addClass("d-none")}}show(n,t,i){this._context=new ModalContext({oldValue:n,callback:i});t??=TextEditor.DEFAULT_OPTIONS;this._showLanguage(t.language);this._flask.updateLanguage(t.language);this._flask.updateCode(n);this._modal.show()}}class PropGrid{_tweakpaneElem;_tweakpane;_phrases;_eventSource=document.createElement("prop-grid");_selectedObject=null;_topObject=null;_topPropertyName="";_parentStack=[];constructor(n,t){this._tweakpaneElem=$("#"+n);this._tweakpane=new Tweakpane({container:this._tweakpaneElem[0]});this._tweakpane.registerPlugin(TweakpaneEssentialsPlugin);this._phrases=t??{};this._bindEvents()}_bindEvents(){this._tweakpaneElem.on("click",".rs-array-item",n=>{this._tweakpaneElem.find(".rs-array-item").removeClass("rs-selected"),$(n.currentTarget).addClass("rs-selected")})}_selectObject(n){this._selectedObject=n;this._parentStack=[];this._topObject=n;this._topPropertyName="";this._showObjectProperties(n,!1)}_selectChildObject(n,t){let i=this._selectedObject;i===this._topObject&&(this._topPropertyName=n);this._selectedObject=t;this._parentStack.push(i);this._showObjectProperties(t,!0)}_selectParentObject(){let n=this._parentStack.pop(),t=this._parentStack.length>0;t||(this._topPropertyName="");this._selectedObject=n;this._showObjectProperties(n,t)}_showObjectProperties(n,t){this._clearPane();let i=PropGridHelper.getTargetObject(n),r=PropGridHelper.getObjectDescriptor(n),u=this._addFolders(i,r);this._addBlades(u,i,t,r)}_clearPane(){for(let n of this._tweakpane.children)n.dispose()}_addBlades(n,t,i,r){if(t)if(Array.isArray(t)){this._addArrayToolbar(t);let i=0;for(let[f,u]of Object.entries(t)){let e=this._addBlade(n,t,f,u,r);this._prepareArrayBlade(e,u,i);i++}}else{let i=Object.entries(t);r&&r.sorted&&i.sort(([n],[t])=>{let i=r.get(n)?.displayName??n,u=r.get(t)?.displayName??t;return i.localeCompare(u)});for(let[u,f]of i)this._addBlade(n,t,u,f,r)}if(i)this._tweakpane.addButton({title:this._phrases.backButton}).on("click",()=>{this._selectParentObject()})}_addBlade(n,t,i,r,u){let f=u?.get(i);if(!f||f.isBrowsable){let e=null,o=this._selectContainer(n,f);if(PropGridDialogs.editorSupported(f))e=o.addButton({label:f.displayName,title:this._getEditButtonText(r)}).on("click",()=>{PropGridDialogs.showEditor(r,f,n=>{r=n,e.title=this._getEditButtonText(r),t[i]=r,this._handleBindingChange(t,i,r)})});else if(typeof r=="number"||typeof r=="string"||typeof r=="boolean")e=o.addBinding(t,i,this._getBindingOptions(f)).on("change",n=>{n.last&&this._handleBindingChange(t,i,n.value)});else if(r instanceof Object){let n=this._createProxyObject(r,f);e=n?o.addBinding({[i]:n},i,this._getBindingOptions(f)).on("change",n=>{n.last&&this._handleBindingChange(t,i,n.value)}):o.addButton({label:f?f.displayName:i,title:this._phrases.editButton}).on("click",()=>{this._selectChildObject(i,r)})}return e}}_addFolders(n,t){let i=new Map;if(n&&t){let r=new Set;for(let i of t.propertyDescriptors.values())n.hasOwnProperty(i.name)&&i.isBrowsable&&i.category&&r.add(i.category);for(let n of Array.from(r).sort())i.set(n,this._tweakpane.addFolder({title:n}))}return i}_selectContainer(n,t){return t&&t.category?n.get(t.category)??this._tweakpane:this._tweakpane}_getEditButtonText(n){const i=20;let t=n?n.toString().trimStart():"";return t?t.length>i?t.substring(0,i)+"...":t:this._phrases.editButton}_createProxyObject(n,t){if(!t)return null;const u=rs.mimic.BasicType,r=rs.mimic.Subtype;let i=null;if(t.type===u.STRUCT)switch(t.subtype){case r.POINT:i=new PointProxy(n);break;case r.SIZE:i=new SizeProxy(n)}return i}_getBindingOptions(n){if(!n)return null;const i=rs.mimic.BasicType,r=rs.mimic.Subtype;let t={label:n.displayName};n.isReadOnly&&(t.readonly=!0,t.interval=0);switch(n.type){case i.INT:t.format=n=>n.toFixed();t.step=1;break;case i.STRING:t.view="text";break;case i.STRUCT:(n.subtype===r.POINT||n.subtype===r.SIZE)&&(t.x={step:1},t.y={step:1})}return Object.assign(t,n.tweakpaneOptions),t}_handleBindingChange(n,t,i){i instanceof ProxyObject&&(i=i.target);let f=PropGridHelper.getTargetObject(this._topObject),r="",u=null;f===n?(r=t,u=i):f&&(r=this._topPropertyName,u=f[this._topPropertyName]);this._topObject instanceof UnionObject&&this._topObject.setProperty(r,u);this._eventSource.dispatchEvent(new CustomEvent(PropGridEventType.PROPERTY_CHANGED,{detail:{selectedObject:this._selectedObject,topObject:this._topObject,targetObject:n,propertyName:t,propertyValue:i,topPropertyName:r,topPropertyValue:u}}))}_handleError(n){console.error(n);this._eventSource.dispatchEvent(new CustomEvent(PropGridEventType.ERROR,{detail:{message:n}}))}_addArrayToolbar(n){this._tweakpane.addBlade({view:"buttongrid",size:[4,1],cells:(n,t)=>({title:[[this._phrases.addButton,this._phrases.upButton,this._phrases.downButton,this._phrases.deleteButton]][t][n]})}).on("click",t=>{switch(t.index[0]){case 0:this._addArrayItem(n);break;case 1:this._moveUpArrayItem(n);break;case 2:this._moveDownArrayItem(n);break;case 3:this._deleteArrayItem(n)}})}_prepareArrayBlade(n,t,i){n&&(n.label=t.displayName||this._phrases.arrayItem+i,$(n.element).addClass("rs-array-item").attr("data-rs-index",i))}_getSelectedIndex(){let n=this._tweakpaneElem.find(".rs-array-item.rs-selected:first").data("rs-index");return n>=0?n:-1}_setSelectedIndex(n){let t=this._tweakpaneElem.find(".rs-array-item");t.removeClass("rs-selected");t.filter(`[data-rs-index="${n}"]`).addClass("rs-selected")}_addArrayItem(n){let t=!1;if(n.createItem instanceof Function){let i=n.createItem();if(i!==undefined&&i!==null){let r=this._getSelectedIndex();r<0?(r=n.length,n.push(i)):(r++,n.splice(r,0,i));this._handleArrayChange(n);this.refresh();this._setSelectedIndex(r);t=!0}}t||this._handleError(this._phrases.unableAddItem)}_moveUpArrayItem(n){let t=this._getSelectedIndex();t>0?([n[t-1],n[t]]=[n[t],n[t-1]],this._handleArrayChange(n),this.refresh(),this._setSelectedIndex(t-1)):this._handleError(this._phrases.unableMoveItem)}_moveDownArrayItem(n){let t=this._getSelectedIndex();0<=t&&t<n.length-1?([n[t],n[t+1]]=[n[t+1],n[t]],this._handleArrayChange(n),this.refresh(),this._setSelectedIndex(t+1)):this._handleError(this._phrases.unableMoveItem)}_deleteArrayItem(n){let t=this._getSelectedIndex();t>=0?(n.splice(t,1),this._handleArrayChange(n),this.refresh()):this._handleError(this._phrases.unableDeleteItem)}_handleArrayChange(n){this._handleBindingChange(n,"",null)}get selectedObject(){return this._selectedObject}set selectedObject(n){this._selectedObject!==n&&this._selectObject(n)}get selectedObjects(){return this._selectedObject instanceof UnionObject?this._selectedObject.targets:[this._selectedObject]}set selectedObjects(n){Array.isArray(n)&&(this.selectedObject=n.length===0?null:n.length===1?n[0]:new UnionObject(n))}addEventListener(n,t){this._eventSource.addEventListener(n,t)}refreshProperty(n){for(let t of this._tweakpane.children)for(let i of t.children)if(i.key===n){i.refresh();return}}refresh(n){if(this._selectedObject instanceof UnionObject){let n=new UnionObject(this._selectedObject.targets);this._selectObject(n)}else if(n)this._selectObject(this._topObject);else{let n=this._selectedObject!==this._topObject;this._showObjectProperties(this._selectedObject,n)}}}class PropGridEventType{static ERROR="error";static PROPERTY_CHANGED="propertyChanged";}class PropGridHelper{static _translationRef=null;static _translateObject(n,t,i,r){if(i){const u=rs.mimic.BasicType;for(let f of n.propertyDescriptors.values()){let n=i[f.name]??(r?r[f.name]:""),e=t.category[f.category];if(n&&(f.displayName=n),e&&(f.category=e),f.type===u.ENUM){let n=t.enumerations.get(f.subtype);n&&(f.tweakpaneOptions??={},f.tweakpaneOptions.options??=n)}}}}static translateDescriptors(n){const t=rs.mimic.DescriptorSet;PropGridHelper._translationRef=n;PropGridHelper._translateObject(t.mimicDescriptor,n,n.mimic);for(let[i,r]of t.componentDescriptors)PropGridHelper._translateObject(r,n,n.components.get(i),n.component);for(let[i,r]of t.structureDescriptors)PropGridHelper._translateObject(r,n,n.structures.get(i))}static getTargetObject(n){return n instanceof rs.mimic.Mimic?n.document:n instanceof rs.mimic.Component?n.properties:n instanceof UnionObject?n.properties:n instanceof Object?n:null}static getObjectDescriptor(n){const t=rs.mimic.DescriptorSet;if(n instanceof rs.mimic.FaceplateInstance){let r=t.getFaceplateDescriptor(n.model),i=PropGridHelper._translationRef;return i&&PropGridHelper._translateObject(r,i,i.component),r}return n instanceof rs.mimic.Component?t.componentDescriptors.get(n.typeName):n instanceof rs.mimic.Mimic?t.mimicDescriptor:n instanceof UnionObject?n.descriptor:n instanceof Object&&n.typeName?t.structureDescriptors.get(n.typeName):null}}class PropGridDialogs{static colorModal=null;static fontModal=null;static imageModal=null;static propertyModal=null;static textEditor=null;static _invokeCallback(n,t){n.result&&t instanceof Function&&t(n.newValue)}static editorSupported(n){const i=rs.mimic.PropertyEditor;let t=n?.editor;return t&&t===i.COLOR_DIALOG&&PropGridDialogs.colorModal||t===i.FONT_DIALOG&&PropGridDialogs.fontModal||t===i.IMAGE_DIALOG&&PropGridDialogs.imageModal||t===i.PROPERTY_DIALOG&&PropGridDialogs.propertyModal||t===i.TEXT_EDITOR&&PropGridDialogs.textEditor}static showEditor(n,t,i){if(t){const r=rs.mimic.PropertyEditor;let u=t.editorOptions;switch(t.editor){case r.FONT_DIALOG:PropGridDialogs.fontModal?.show(n,n=>{PropGridDialogs._invokeCallback(n,i)});break;case r.TEXT_EDITOR:PropGridDialogs.textEditor?.show(n,u,n=>{PropGridDialogs._invokeCallback(n,i)})}}}}class ProxyObject{target;constructor(n){if(n)this.target=n;else throw new Error("Target must not be null.");}}class PointProxy extends ProxyObject{get x(){return parseInt(this.target.x)||0}set x(n){this.target.x=n}get y(){return parseInt(this.target.y)||0}set y(n){this.target.y=n}}class SizeProxy extends ProxyObject{get x(){return parseInt(this.target.width)||0}set x(n){this.target.width=n}get y(){return parseInt(this.target.height)||0}set y(n){this.target.height=n}}class UnionObject{targets;properties;descriptor;constructor(n){if(Array.isArray(n))this.targets=n;else throw new Error("Targets must be an array.");this._buildProperties()}_buildProperties(){this.properties={};this.descriptor=new rs.mimic.ObjectDescriptor;let n=0;for(let t of this.targets){let r=PropGridHelper.getObjectDescriptor(t),i=this._getEditableObject(t);if(n===0)for(let[n,t]of Object.entries(i)){this.properties[n]=ScadaUtils.deepClone(t,!0);let i=r.get(n);i&&i.type!==rs.mimic.BasicType.LIST&&this.descriptor.add(i)}else for(let[n,t]of Object.entries(this.properties)){let u=this.descriptor.get(n),f=r.get(n);if(i.hasOwnProperty(n)&&this._sameProperties(u,f)){let r=i[n];this._sameValues(t,r)||(this.properties[n]=this._mergeValues(t,r))}else delete this.properties[n],this.descriptor.delete(n)}n++}}_getEditableObject(n){return n instanceof rs.mimic.Mimic?n.document:n instanceof rs.mimic.Component?n.properties:n instanceof Object?n:{}}_sameProperties(n,t){return n===t||n&&t&&n.type===t.type&&n.subtype===t.subtype}_sameValues(n,t){let i=JSON.stringify(n),r=JSON.stringify(t);return i===r}_mergeValues(n,t){if(Array.isArray(n))return null;if(typeof n=="number")return n===t?n:0;if(typeof n=="string")return n===t?n:"";if(typeof n=="boolean")return n===t?n:!1;if(n instanceof Object){let i={};for(let[r,u]of Object.entries(n))i[r]=this._mergeValues(u,t[r]);return i}return null}setProperty(n,t){for(let i of this.targets){let r=this._getEditableObject(i);r[n]=ScadaUtils.deepClone(t,!0)}}toString(){return"Union"}}class StructTree{_eventSource=document.createElement("struct-tree");structElem;mimic;phrases;constructor(n,t,i){this.structElem=$("#"+n);this.mimic=t;this.phrases=i??{}}_prepareDependencies(n){let t=$("<span class='node node-dependencies'><\/span>");$("<span class='node-text'><\/span>").text(this.phrases.dependenciesNode).appendTo(t);$("<span class='node-btn add-btn'><i class='fa-solid fa-plus'><\/i><\/span>").appendTo(t);let i=$("<li class='item-dependencies'><\/li>").append(t).appendTo(n),r=$("<ul class='list-dependencies'><\/ul>").appendTo(i);this._appendDependencies(r)}_appendDependencies(n){for(let t of this.mimic.dependencies)if(!t.isTransitive){let i=$("<span class='node node-dependency'><\/span>");$("<span class='node-text'><\/span>").text(t.typeName).appendTo(i);$("<span class='node-btn edit-btn'><i class='fa-solid fa-pen-to-square'><\/i><\/span>").appendTo(i);$("<span class='node-btn remove-btn'><i class='fa-regular fa-trash-can'><\/i><\/span>").appendTo(i);$("<li class='item-dependency'><\/li>").attr("data-name",t.typeName).addClass(t.hasError?"has-error":"").append(i).appendTo(n)}}_prepareImages(n){let t=$("<span class='node node-images'><\/span>");$("<span class='node-text'><\/span>").text(this.phrases.imagesNode).appendTo(t);$("<span class='node-btn add-btn'><i class='fa-solid fa-plus'><\/i><\/span>").appendTo(t);let i=$("<li class='item-images'><\/li>").append(t).appendTo(n),r=$("<ul class='list-images'><\/ul>").appendTo(i);this._appendImages(r)}_appendImages(n){for(let t of this.mimic.images){let i=$("<span class='node node-image'><\/span>");$("<span class='node-text'><\/span>").text(t.name).appendTo(i);let r=$("<span class='node-btn view-btn'><i class='fa-regular fa-eye'><\/i><\/span>").appendTo(i);$("<span class='node-btn edit-btn'><i class='fa-solid fa-pen-to-square'><\/i><\/span>").appendTo(i);$("<span class='node-btn remove-btn'><i class='fa-regular fa-trash-can'><\/i><\/span>").appendTo(i);$("<li class='item-image'><\/li>").attr("data-name",t.name).append(i).appendTo(n);this._initImagePopover(r,t.name)}}_initImagePopover(n,t){const i=this;bootstrap.Popover.getOrCreateInstance(n[0],{html:!0,placement:"bottom",trigger:"hover",content:function(){let r=n.data("popoverContent");if(!r){let u=i.mimic.imageMap.get(t)?.dataUrl;r=u?`<img class="image-preview" src="${u}" />`:i.phrases.noImagePreview;n.data("popoverContent",r)}return r}})}_prepareComponents(n){let t=$("<span class='node node-mimic'><\/span>").text(this.phrases.mimicNode),i=$("<li class='item-mimic'><\/li>").append(t).appendTo(n),r=$("<ul class='list-components'><\/ul>").appendTo(i);this._appendComponents(r)}_appendComponents(n){for(let t of this.mimic.children)this._appendComponent(n,t)}_appendComponent(n,t){let i=$("<span class='node node-comp'><\/span>").text(t.displayName),r=$("<li class='item-comp'><\/li>").attr("id","struct-comp-item"+t.id).attr("data-id",t.id).append(i).appendTo(n);if(t.isContainer){let n=$("<ul><\/ul>").appendTo(r);for(let i of t.children)this._appendComponent(n,i)}t.isSelected&&i.addClass("selected")}_bindEvents(n){const t=this;n.find(".item-dependencies").on("click",".add-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.ADD_DEPENDENCY_CLICK))}).on("click",".edit-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.EDIT_DEPENDENCY_CLICK,{detail:{name:$(this).closest(".item-dependency").data("name")}}))}).on("click",".remove-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.REMOVE_DEPENDENCY_CLICK,{detail:{name:$(this).closest(".item-dependency").data("name")}}))});n.find(".item-images").on("click",".add-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.ADD_IMAGE_CLICK))}).on("click",".edit-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.EDIT_IMAGE_CLICK,{detail:{name:$(this).closest(".item-image").data("name")}}))}).on("click",".remove-btn",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.REMOVE_IMAGE_CLICK,{detail:{name:$(this).closest(".item-image").data("name")}}))});n.find(".item-mimic").on("click",".node-mimic",function(){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.MIMIC_CLICK))}).on("click",".node-comp",function(n){t._eventSource.dispatchEvent(new CustomEvent(StructTreeEventType.COMPONENT_CLICK,{detail:{componentID:$(this).parent().data("id"),isSelected:$(this).hasClass("selected"),ctrlKey:n.ctrlKey}}))})}_findMimicItem(){return this.structElem.find(".item-mimic")}_findComponentItem(n){return this.structElem.find("#struct-comp-item"+n.id)}_findComponentNode(n){return this._findComponentItem(n).children(".node")}build(){let n=$("<ul class='list-top'><\/ul>");this._prepareDependencies(n);this._prepareImages(n);this._prepareComponents(n);this._bindEvents(n);let t=this.structElem.find(".list-top:first");t.length>0?t.replaceWith(n):this.structElem.append(n)}refreshDependencies(){let t=this.structElem.find(".list-dependencies:first"),n=$("<ul class='list-dependencies'><\/ul>");this._appendDependencies(n);t.replaceWith(n)}refreshImages(){let t=this.structElem.find(".list-images:first"),n=$("<ul class='list-images'><\/ul>");this._appendImages(n);t.replaceWith(n)}refreshComponents(n){if(n instanceof rs.mimic.Mimic){let t=this.structElem.find(".list-components:first"),n=$("<ul class='list-components'><\/ul>");this._appendComponents(n);t.replaceWith(n)}else if(n instanceof rs.mimic.Component){let i=this._findComponentItem(n),r=i.children("ul:first"),t=$("<ul><\/ul>");for(let i of n.children)this._appendComponent(t,i);r.replaceWith(t)}}addComponent(n){let t=n.parentID>0?this.structElem.find(`#struct-comp-item${n.parentID}>ul`):this.structElem.find(".item-mimic>ul");t.length>0&&this._appendComponent(t,n)}updateComponent(n){this._findComponentNode(n).text(n.displayName)}removeComponent(n){this.structElem.find("#struct-comp-item"+n).remove()}selectMimic(){let n=this._findMimicItem();n.children(".node").addClass("selected");n.children("ul").find(".node").removeClass("selected")}selectNone(){this._findMimicItem().find(".node").removeClass("selected")}selectComponents(n){if(this.selectNone(),Array.isArray(n))for(let t of n)this._findComponentNode(t).addClass("selected")}addToSelection(n){this._findMimicItem().children(".node").removeClass("selected");this._findComponentNode(n).addClass("selected")}removeFromSelection(n){this._findComponentNode(n).removeClass("selected")}addEventListener(n,t){this._eventSource.addEventListener(n,t)}}class StructTreeEventType{static ADD_DEPENDENCY_CLICK="addDependencyClick";static EDIT_DEPENDENCY_CLICK="editDependencyClick";static REMOVE_DEPENDENCY_CLICK="removeDependencyClick";static ADD_IMAGE_CLICK="addImageClick";static EDIT_IMAGE_CLICK="editImageClick";static REMOVE_IMAGE_CLICK="removeImageClick";static MIMIC_CLICK="mimicClick";static COMPONENT_CLICK="componentClick";}